/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.hover;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.contentassist.ILexemeProvider;
import com.aptana.editor.common.hover.CustomBrowserInformationControl;
import com.aptana.editor.common.hover.DocumentationBrowserInformationControlInput;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.internal.builder.LocalModule;
import com.aptana.editor.php.internal.contentAssist.ContentAssistUtils;
import com.aptana.editor.php.internal.contentAssist.PHPTokenType;
import com.aptana.editor.php.internal.contentAssist.ParsingUtils;
import com.aptana.editor.php.internal.contentAssist.mapping.PHPOffsetMapper;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.indexer.AbstractPHPEntryValue;
import com.aptana.editor.php.internal.indexer.PHPDocUtils;
import com.aptana.editor.php.internal.indexer.VariablePHPEntryValue;
import com.aptana.editor.php.internal.parser.nodes.PHPBaseParseNode;
import com.aptana.editor.php.internal.parser.phpdoc.FunctionDocumentation;
import com.aptana.editor.php.internal.ui.editor.PHPSourceEditor;
import com.aptana.editor.php.internal.ui.editor.hyperlink.PHPHyperlinkDetector;
import com.aptana.editor.php.internal.ui.hover.AbstractPHPTextHover;
import com.aptana.editor.php.internal.ui.hover.Messages;
import com.aptana.ide.ui.io.internal.UniformFileStoreEditorInput;
import com.aptana.parsing.lexer.Lexeme;
import com.aptana.ui.epl.UIEplPlugin;
import com.aptana.ui.util.UIUtils;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.text.html.BrowserInformationControlInput;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInputChangedListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;
import org2.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org2.eclipse.php.internal.core.documentModel.phpElementData.IPHPDoc;

public class PHPTextHover
extends AbstractPHPTextHover {
    public String getHeader(Object element, IEditorPart editorPart, IRegion hoverRegion) {
        if (element instanceof IElementEntry) {
            IElementEntry entry = (IElementEntry)element;
            if (entry.getModule() != null) {
                UniformFileStoreEditorInput uniformInput;
                String moduleName = entry.getModule().getShortName();
                if (editorPart != null && editorPart.getEditorInput() instanceof UniformFileStoreEditorInput && (uniformInput = (UniformFileStoreEditorInput)editorPart.getEditorInput()).isRemote()) {
                    moduleName = editorPart.getTitle();
                }
                return moduleName;
            }
        } else if (element instanceof PHPBaseParseNode) {
            return Messages.PHPTextHover_phpAPIHeader;
        }
        return null;
    }

    public String getDocumentation(Object element, IEditorPart editorPart, IRegion hoverRegion) {
        String computedDocumentation = null;
        if (element instanceof IElementEntry) {
            FunctionDocumentation documentation;
            ISourceViewer sourceViewer;
            IElementEntry entry = (IElementEntry)element;
            AbstractPHPEntryValue phpValue = (AbstractPHPEntryValue)entry.getValue();
            int startOffset = phpValue.getStartOffset();
            IDocument document = null;
            if (editorPart != null && (sourceViewer = (ISourceViewer)editorPart.getAdapter(ISourceViewer.class)) != null) {
                document = sourceViewer.getDocument();
            }
            PHPDocBlock comment = PHPDocUtils.findFunctionPHPDocComment(entry, document, startOffset);
            if (phpValue instanceof VariablePHPEntryValue && ((VariablePHPEntryValue)phpValue).isParameter()) {
                try {
                    documentation = PHPDocUtils.getParameterDocumentation((IPHPDoc)comment, document.get(hoverRegion.getOffset(), hoverRegion.getLength()));
                }
                catch (BadLocationException e) {
                    IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (Throwable)e);
                    documentation = null;
                }
            } else {
                documentation = PHPDocUtils.getFunctionDocumentation((IPHPDoc)comment);
            }
            computedDocumentation = PHPDocUtils.computeDocumentation(documentation, document, entry.getEntryPath());
        } else if (element instanceof PHPBaseParseNode) {
            PHPBaseParseNode node = (PHPBaseParseNode)element;
            computedDocumentation = ContentAssistUtils.getDocumentation(node, node.getNodeName());
        }
        return computedDocumentation;
    }

    public void populateToolbarActions(ToolBarManager tbm, CustomBrowserInformationControl iControl) {
        final OpenDeclarationAction openDeclarationAction = new OpenDeclarationAction(iControl);
        tbm.add((IAction)openDeclarationAction);
        IInputChangedListener inputChangeListener = new IInputChangedListener(){

            public void inputChanged(Object newInput) {
                if (newInput instanceof BrowserInformationControlInput) {
                    openDeclarationAction.update();
                }
            }
        };
        iControl.addInputChangeListener(inputChangeListener);
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        if (this.isHoverEnabled().booleanValue()) {
            IFile moduleFile;
            IEditorInput editorInput;
            IFile resource;
            Object[] elements = this.getPHPElementsAt(textViewer, hoverRegion);
            if (ArrayUtil.isEmpty((Object[])elements) || elements[0] == null) {
                return null;
            }
            IEditorPart editor = this.getEditor();
            if (editor != null && (resource = (IFile)(editorInput = editor.getEditorInput()).getAdapter(IFile.class)) != null && (moduleFile = this.getModuleFile(elements[0])) != null && !moduleFile.equals((Object)resource)) {
                final IEditorPart[] moduleEditorPart = new IEditorPart[1];
                UIUtils.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchPage activePage = UIUtils.getActivePage();
                        if (activePage != null) {
                            moduleEditorPart[0] = activePage.findEditor((IEditorInput)new FileEditorInput(moduleFile));
                        }
                    }
                });
                editor = moduleEditorPart[0];
            }
            return this.getHoverInfo(elements[0], this.isBrowserControlAvailable(textViewer), null, editor, hoverRegion);
        }
        return null;
    }

    private IFile getModuleFile(Object element) {
        IModule module;
        if (element instanceof IElementEntry && (module = ((IElementEntry)element).getModule()) instanceof LocalModule) {
            return ((LocalModule)module).getFile();
        }
        return null;
    }

    protected Object[] getPHPElementsAt(ITextViewer textViewer, IRegion hoverRegion) {
        PHPSourceEditor editor = (PHPSourceEditor)this.getEditor();
        if (editor == null) {
            return null;
        }
        ILexemeProvider<PHPTokenType> lexemeProvider = ParsingUtils.createLexemeProvider(editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()), hoverRegion.getOffset());
        Lexeme lexeme = lexemeProvider.getLexemeFromOffset(hoverRegion.getOffset());
        if (lexeme == null) {
            return null;
        }
        PHPOffsetMapper offsetMapper = editor.getOffsetMapper();
        Object entry = offsetMapper.findEntry((Lexeme<PHPTokenType>)lexeme, lexemeProvider);
        if (entry == null) {
            try {
                List<Object> elements;
                String name = textViewer.getDocument().get(hoverRegion.getOffset(), hoverRegion.getLength());
                if (!StringUtil.isEmpty((String)name) && !CollectionsUtil.isEmpty(elements = ContentAssistUtils.selectModelElements(name, true))) {
                    entry = elements.get(0);
                }
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)("PHP documentation hover - error getting an element at offset - " + hoverRegion.getOffset()), (Throwable)e);
            }
        }
        if (entry != null) {
            return new Object[]{entry};
        }
        return null;
    }

    public class OpenDeclarationAction
    extends Action {
        private static final String IMG_OPEN_DECLARATION = "icons/full/elcl16/goto_input.gif";
        private static final String IMG_OPEN_DECLARATION_DISABLED = "icons/full/dlcl16/goto_input.gif";
        private CustomBrowserInformationControl iControl;
        private IHyperlink[] hyperlinks;

        public OpenDeclarationAction(CustomBrowserInformationControl iControl) {
            this.setText(Messages.PHPTextHover_openDeclarationTooltip);
            this.setImageDescriptor(UIEplPlugin.imageDescriptorFromPlugin((String)"com.aptana.ui.epl", (String)IMG_OPEN_DECLARATION));
            this.setDisabledImageDescriptor(UIEplPlugin.imageDescriptorFromPlugin((String)"com.aptana.ui.epl", (String)IMG_OPEN_DECLARATION_DISABLED));
            this.iControl = iControl;
        }

        void update() {
            BrowserInformationControlInput input = this.iControl.getInput();
            if (input instanceof DocumentationBrowserInformationControlInput) {
                PHPHyperlinkDetector detector = new PHPHyperlinkDetector();
                IRegion hoverRegion = ((DocumentationBrowserInformationControlInput)input).getHoverRegion();
                if (hoverRegion != null) {
                    this.hyperlinks = detector.detectHyperlinks((PHPSourceEditor)PHPTextHover.this.getEditor(), hoverRegion, false);
                    this.setEnabled(!ArrayUtil.isEmpty((Object[])this.hyperlinks) && this.hyperlinks[0] != null);
                    return;
                }
            }
            this.setEnabled(false);
        }

        public void run() {
            this.iControl.dispose();
            this.hyperlinks[0].open();
        }
    }
}

